/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.managers.ThreadWaitingList;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;

public class SceKernelMppInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int attr;
    public final int bufSize;
    public int freeSize;
    public final ThreadWaitingList sendThreadWaitingList;
    public final ThreadWaitingList receiveThreadWaitingList;
    private final SysMemUserForUser.SysMemInfo sysMemInfo;
    public final int uid;
    public final int partitionid;
    public final int address;
    private int head;
    private int tail;
    private static final String uidPurpose = "ThreadMan-MsgPipe";
    public int userAddress;
    public int userSize;

    public SceKernelMppInfo(String name, int partitionid, int attr, int size, int memType) {
        this.name = name;
        this.attr = attr;
        this.bufSize = size;
        this.freeSize = size;
        if (size != 0) {
            this.sysMemInfo = Modules.SysMemUserForUserModule.malloc(partitionid, uidPurpose, memType, size, 0);
            this.address = this.sysMemInfo.addr;
        } else {
            this.sysMemInfo = null;
            this.address = 0;
        }
        this.uid = SceUidManager.getNewUid(uidPurpose);
        this.sendThreadWaitingList = ThreadWaitingList.createThreadWaitingList(8, this.uid, attr, 256);
        this.receiveThreadWaitingList = ThreadWaitingList.createThreadWaitingList(8, this.uid, attr, 4096);
        this.partitionid = partitionid;
        this.head = 0;
        this.tail = 0;
    }

    public boolean isMemoryAllocated() {
        return this.bufSize == 0 || this.sysMemInfo != null;
    }

    public void delete() {
        if (this.sysMemInfo != null) {
            Modules.SysMemUserForUserModule.free(this.sysMemInfo);
        }
        SceUidManager.releaseUid(this.uid, uidPurpose);
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.bufSize);
        this.write32(this.freeSize);
        this.write32(this.getNumSendWaitThreads());
        this.write32(this.getNumReceiveWaitThreads());
    }

    public int availableReadSize() {
        if (this.bufSize == 0) {
            return this.getUserSize();
        }
        return this.bufSize - this.freeSize;
    }

    public int availableWriteSize() {
        return this.freeSize;
    }

    public void append(Memory mem, int src, int size) {
        this.freeSize -= size;
        while (size > 0) {
            int copySize = Math.min(this.bufSize - this.tail, size);
            mem.memcpy(this.address + this.tail, src, copySize);
            src += copySize;
            size -= copySize;
            this.tail = (this.tail + copySize) % this.bufSize;
        }
    }

    public void consume(Memory mem, int dst, int size) {
        if (this.bufSize == 0) {
            mem.memcpy(dst, this.userAddress, size);
            this.userAddress += size;
            this.userSize -= size;
        } else {
            this.freeSize += size;
            while (size > 0) {
                int copySize = Math.min(this.bufSize - this.head, size);
                mem.memcpy(dst, this.address + this.head, copySize);
                dst += copySize;
                size -= copySize;
                this.head = (this.head + copySize) % this.bufSize;
            }
        }
    }

    public int getNumSendWaitThreads() {
        return this.sendThreadWaitingList.getNumWaitingThreads();
    }

    public int getNumReceiveWaitThreads() {
        return this.receiveThreadWaitingList.getNumWaitingThreads();
    }

    public void setUserData(int address, int size) {
        this.userAddress = address;
        this.userSize = size;
    }

    public int getUserSize() {
        return this.userSize;
    }

    @Override
    public String toString() {
        return String.format("SceKernelMppInfo(uid=0x%X, name='%s', attr=0x%X, bufSize=0x%X, freeSize=0x%X, numSendWaitThreads=%d, numReceiveWaitThreads=%d)", this.uid, this.name, this.attr, this.bufSize, this.freeSize, this.getNumSendWaitThreads(), this.getNumReceiveWaitThreads());
    }
}

